/*
	File:		PrintErrors.h

	Contains:	Error and problem codes for printing

	Copyright:	 1993-1994 by Apple Computer, Inc., all rights reserved.

	Derived from v11 internal.

		WARNING:	this file is a global errors file and must be
					FRAMable.  please use caution when adding
					anything other than new errors!
*/


#ifndef __PRINTERRORS_H
#define __PRINTERRORS_H


#ifndef __NEWTERRORS_H
#include "NewtErrors.h"
#endif


#define PR_ERROR_BASE									(ERRBASE_PRINTING)
#define PR_PROBLEM_BASE									(ERRBASE_PRINTING - 100)
#define PR_DRIVER_BASE									(ERRBASE_PRINTING - 200)


/* Errors are fatal - these are always (only) returned by TPrinter calls.	*/

#define kPR_ERR_PrinterError							(PR_ERROR_BASE)
#define kPR_ERR_NewtonError								(PR_ERROR_BASE - 1)
#define kPR_ERR_NotFound								(PR_ERROR_BASE - 2)
#define kPR_ERR_Busy	/* out-box should try again! */	(PR_ERROR_BASE - 3)
#define kPR_ERR_UserCancel								(PR_ERROR_BASE - 4)
#define kPR_ERR_LostContact								(PR_ERROR_BASE - 5)
#define kPR_ERR_TooComplex								(PR_ERROR_BASE - 6)

						/* REMEMBER - these are going backwards!	*/
#define kPR_ERR_MINERROR								(PR_ERROR_BASE - 99)
#define kPR_ERR_MAXERROR								(PR_ERROR_BASE - 00)



//  Problems are non-fatal - these are given to the "HandleProblem" callback.
//  However, if the user cancels a problem dialog, this same error code
//  will be returned to the TPrinter call.

//  The problems are sorted in a rough priority scheme, which the drivers
//  can use to select the most severe when multiple errors are being posted
//  by the printer or the comm tools.

#define kPR_PROB_LoadManualFeed							(PR_PROBLEM_BASE - 0)
#define kPR_PROB_FaxManualDial							(PR_PROBLEM_BASE - 1)
#define kPR_PROB_NoPaperTray							(PR_PROBLEM_BASE - 2)
#define kPR_PROB_WrongPaperTray							(PR_PROBLEM_BASE - 3)
#define kPR_PROB_NoPaper								(PR_PROBLEM_BASE - 4)
#define kPR_PROB_NoInk									(PR_PROBLEM_BASE - 5)
#define kPR_PROB_Jammed									(PR_PROBLEM_BASE - 6)
#define kPR_PROB_DoorOpen								(PR_PROBLEM_BASE - 7)
#define kPR_PROB_OffLine								(PR_PROBLEM_BASE - 8)

						/* REMEMBER - these are going backwards!	*/
#define kPR_ERR_MINPROBLEM								(PR_PROBLEM_BASE - 99)
#define kPR_ERR_MAXPROBLEM								(PR_PROBLEM_BASE - 00)


//  This group is never seen by the "outside world".  It is reserved for
//  communication between the imaging engines and the printer drivers.

#define kPR_DRVR_ReprintPage							(PR_DRIVER_BASE - 0)



#endif	// __PRINTERRORS_H

